/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.other;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.network.ReceivePacketEvent;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7439;
import net.minecraft.class_7923;

@ModuleInfo(name="Shard Booster", category=ModuleCategory.OTHER, desc="modules.descriptions.shard_booster")
public class ShardBooster
extends BaseModule {
    private final BooleanSetting autoDetect = new BooleanSetting(this, "modules.settings.shard_booster.auto_detect").enable();
    private final BooleanSetting showEffect = new BooleanSetting(this, "modules.settings.shard_booster.show_effect").enable();
    private final SliderSetting duration = new SliderSetting(this, "modules.settings.shard_booster.duration").min(1.0f).max(48.0f).step(1.0f).currentValue(24.0f);
    private final BooleanSetting debugMode = new BooleanSetting(this, "modules.settings.shard_booster.debug");
    private static class_1291 SHARD_BOOSTER_EFFECT;
    private static class_6880<class_1291> EFFECT_ENTRY;
    private long expiryTime = 0L;
    private Path configFile;
    private boolean effectRegistered = false;
    private final EventListener<ReceivePacketEvent> onPacket = event -> {
        if (!this.autoDetect.isEnabled()) {
            return;
        }
        class_2596<?> patt0$temp = event.getPacket();
        if (!(patt0$temp instanceof class_7439)) {
            return;
        }
        class_7439 packet = (class_7439)patt0$temp;
        String message = packet.comp_763().getString().toLowerCase();
        if (this.debugMode.isEnabled()) {
            MessageUtility.info(class_2561.method_30163((String)("Message: " + message)));
        }
        this.detectShardBoosterMessage(message);
    };
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isActive() && System.currentTimeMillis() >= this.expiryTime) {
            this.deactivate();
        }
        if (this.isActive() && this.showEffect.isEnabled() && ShardBooster.mc.field_1724 != null) {
            this.updateEffect();
        }
    };

    @Override
    public void onEnable() {
        super.onEnable();
        this.initializeEffect();
        this.loadConfig();
        if (this.isActive()) {
            this.applyEffect();
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.removeEffect();
    }

    private void initializeEffect() {
        block4: {
            if (this.effectRegistered) {
                return;
            }
            try {
                SHARD_BOOSTER_EFFECT = (class_1291)class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)class_2960.method_60655((String)"rockstarnew", (String)"shard_booster"), (Object)((Object)new ShardBoosterEffect()));
                EFFECT_ENTRY = class_7923.field_41174.method_47983((Object)SHARD_BOOSTER_EFFECT);
                this.effectRegistered = true;
                if (this.debugMode.isEnabled()) {
                    MessageUtility.info(class_2561.method_30163((String)"Shard Booster effect registered"));
                }
            }
            catch (Exception e) {
                if (!this.debugMode.isEnabled()) break block4;
                MessageUtility.error(class_2561.method_30163((String)("Failed to register effect: " + e.getMessage())));
            }
        }
        this.configFile = class_310.method_1551().field_1697.toPath().resolve("rockstarnew").resolve("shard_booster.txt");
    }

    private void detectShardBoosterMessage(String message) {
        if (message.contains("shard booster") || message.contains("\u0448\u0430\u0440\u0434 \u0431\u0443\u0441\u0442\u0435\u0440")) {
            if (message.contains("activated") || message.contains("enabled") || message.contains("\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d") || message.contains("\u0432\u043a\u043b\u044e\u0447\u0435\u043d")) {
                this.activate();
            } else if (message.contains("deactivated") || message.contains("disabled") || message.contains("\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d") || message.contains("\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d")) {
                this.deactivate();
            }
        }
    }

    public void activate() {
        long durationMs = (long)(this.duration.getCurrentValue() * 3600000.0f);
        this.expiryTime = System.currentTimeMillis() + durationMs;
        this.saveConfig();
        this.applyEffect();
        MessageUtility.info(class_2561.method_30163((String)("\u00a7a\u0428\u0430\u0440\u0434 \u0431\u0443\u0441\u0442\u0435\u0440 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043e: \u00a7f" + this.getFormattedTime())));
        if (this.debugMode.isEnabled()) {
            MessageUtility.info(class_2561.method_30163((String)("Expiry: " + String.valueOf(new Date(this.expiryTime)))));
        }
    }

    public void deactivate() {
        this.expiryTime = 0L;
        this.saveConfig();
        this.removeEffect();
        MessageUtility.info(class_2561.method_30163((String)"\u00a7c\u0428\u0430\u0440\u0434 \u0431\u0443\u0441\u0442\u0435\u0440 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d"));
    }

    private void applyEffect() {
        if (!this.showEffect.isEnabled() || ShardBooster.mc.field_1724 == null || EFFECT_ENTRY == null) {
            return;
        }
        int ticks = this.getRemainingTicks();
        if (ticks > 0) {
            class_1293 instance = new class_1293(EFFECT_ENTRY, ticks, 0, false, true, true);
            ShardBooster.mc.field_1724.method_6092(instance);
        }
    }

    private void updateEffect() {
        if (ShardBooster.mc.field_1724 == null || EFFECT_ENTRY == null) {
            return;
        }
        class_1293 current = ShardBooster.mc.field_1724.method_6112(EFFECT_ENTRY);
        int remaining = this.getRemainingTicks();
        if (remaining <= 0) {
            this.removeEffect();
            return;
        }
        if (current == null || Math.abs(current.method_5584() - remaining) > 100) {
            class_1293 instance = new class_1293(EFFECT_ENTRY, remaining, 0, false, true, true);
            ShardBooster.mc.field_1724.method_6092(instance);
        }
    }

    private void removeEffect() {
        if (ShardBooster.mc.field_1724 != null && EFFECT_ENTRY != null) {
            ShardBooster.mc.field_1724.method_6016(EFFECT_ENTRY);
        }
    }

    public boolean isActive() {
        if (this.expiryTime == 0L) {
            return false;
        }
        if (System.currentTimeMillis() >= this.expiryTime) {
            this.deactivate();
            return false;
        }
        return true;
    }

    public long getRemainingTime() {
        if (!this.isActive()) {
            return 0L;
        }
        return this.expiryTime - System.currentTimeMillis();
    }

    public int getRemainingTicks() {
        return (int)(this.getRemainingTime() / 50L);
    }

    public String getFormattedTime() {
        long remaining = this.getRemainingTime();
        if (remaining <= 0L) {
            return "00:00:00";
        }
        long seconds = remaining / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    private void loadConfig() {
        try {
            if (Files.exists(this.configFile, new LinkOption[0])) {
                String content = Files.readString(this.configFile);
                this.expiryTime = Long.parseLong(content.trim());
                if (this.debugMode.isEnabled()) {
                    MessageUtility.info(class_2561.method_30163((String)("Loaded config: " + String.valueOf(new Date(this.expiryTime)))));
                }
            }
        }
        catch (IOException | NumberFormatException e) {
            if (this.debugMode.isEnabled()) {
                MessageUtility.error(class_2561.method_30163((String)("Failed to load config: " + e.getMessage())));
            }
            this.expiryTime = 0L;
        }
    }

    private void saveConfig() {
        block2: {
            try {
                Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
                Files.writeString(this.configFile, (CharSequence)String.valueOf(this.expiryTime), new OpenOption[0]);
            }
            catch (IOException e) {
                if (!this.debugMode.isEnabled()) break block2;
                MessageUtility.error(class_2561.method_30163((String)("Failed to save config: " + e.getMessage())));
            }
        }
    }

    private static class ShardBoosterEffect
    extends class_1291 {
        public ShardBoosterEffect() {
            super(class_4081.field_18271, 15054640);
        }

        public boolean method_5552(int duration, int amplifier) {
            return false;
        }

        public boolean method_5573() {
            return true;
        }
    }
}

